//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui   1.0
import wesual.Util 1.0

Item {
    id : uiDrawer

    property bool   collapsed : false
    property string label
    property alias  properties : content.properties
    property int    bottomPadding : 12
    property bool   bindable : false

    property Component headerDelegate : defaultHeader

    default property alias component : content.sourceComponent

    readonly property Item contentItem : content.item

    signal headerClicked()

    implicitHeight : content.implicitHeight + header.height + bottomPadding
    implicitWidth  : content.implicitWidth
    enabled        : true

    Component.onCompleted : {
        collapseTransition.enabled = true;
        expandTransition.enabled   = true;
    }

    Component {
        id : defaultHeader

        Item {
            implicitHeight : 36

            states :  [
                State {
                    name : "collapsed"
                    when : uiDrawer.collapsed

                    PropertyChanges {
                        target   : arrow
                        rotation : -90
                        opacity  : .8
                    }
                }
            ]

            transitions : Transition {
                NumberAnimation {
                    property    : "rotation"
                    duration    : 70
                    easing.type : Easing.OutQuad
                }
            }

            Image {
                id : arrow

                source   : "qrc:/ui/images/collapse-arrow.svg"
                rotation : 0
                x        : 2

                anchors.verticalCenter : parent.verticalCenter
            }

            Text {
                id : label

                x     : 22
                text  : uiDrawer.label
                font  : UiFonts.getFont(UiFonts.RegularCapitalized, 14)
                color : UiColors.getColor(UiColors.MediumDarkGrey67)

                anchors.verticalCenter : parent.verticalCenter
            }

            MouseArea {
                height      : 20
                onClicked   : {
                    if (!bindable) {
                        collapsed = !collapsed;
                    }
                    uiDrawer.headerClicked()
                }
                cursorShape : Qt.PointingHandCursor

                anchors {
                    left  : parent.left
                    right : label.right
                    verticalCenter : parent.verticalCenter
                }
            }
        }
    }

    Loader {
        id : header

        opacity : !uiDrawer.enabled ? .6 : 1
        sourceComponent : uiDrawer.headerDelegate
        anchors {
            left : uiDrawer.left
            right : uiDrawer.right
        }
    }

    states :  [
        State {
            name : "collapsed"
            when : uiDrawer.collapsed

            PropertyChanges {
                target  : content
                opacity : 0
            }
            PropertyChanges {
                target         : uiDrawer
                implicitHeight : header.height
            }
        }
    ]

    transitions : [
        Transition {
            id : collapseTransition

            to      : "collapsed"
            enabled : false

            SequentialAnimation {
                PauseAnimation { duration : 70 }
                NumberAnimation {
                    property    : "opacity"
                    easing.type : Easing.InOutSine
                }
                NumberAnimation {
                    property    : "implicitHeight"
                    easing.type : Easing.OutQuad
                }
            }
        },
        Transition {
            id : expandTransition

            from    : "collapsed"
            enabled : false

            SequentialAnimation {
                PauseAnimation { duration : 70 }
                NumberAnimation {
                    property    : "implicitHeight"
                    easing.type : Easing.InQuad
                }
                NumberAnimation {
                    property    : "opacity"
                    easing.type : Easing.InOutSine
                }
            }
        }
    ]

    UiLoader {
        id : content

        anchors {
            fill         : uiDrawer
            topMargin    : header.height
            bottomMargin : bottomPadding
        }

        enabled : !uiDrawer.collapsed
    }
}
